package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.databinding.ObservableBoolean
import androidx.databinding.ObservableInt
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.R
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.HomeModel
import com.qboxus.tictic.repositories.VideosRepository
import com.qboxus.tictic.simpleclasses.Functions
import kotlinx.coroutines.launch
import org.json.JSONObject

class FavouriteVideosViewModel(
    private val context: Context,
    private val videoRepository: VideosRepository

) : ViewModel(){

    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences=Functions.getSharedPreference(context)
    }

    var userName: String? = null
    var isUserAlreadyBlock: String? = null

    var ispostFinsh = false
    var isApiRun = false
    var isScrollToTop=true


    var pageCount: ObservableInt = ObservableInt(0)

    val _videosLiveData: MutableLiveData<ApiResponce<ArrayList<HomeModel>>> = MutableLiveData()
    val videosLiveData: LiveData<ApiResponce<ArrayList<HomeModel>>> get() = _videosLiveData

    fun showFavouriteVideos(userId:String){
        viewModelScope.launch {

            val params = JSONObject().apply {
                put("user_id", userId);
                put("starting_point", pageCount.get().toString())

            }
            videoRepository.showFavouriteVideos(params,_videosLiveData)
        }
    }

    var dataLayoutVisibility = ObservableBoolean(false)
    var noDataLayoutVisibility = ObservableBoolean(false)
    var loadMoreProgressVisibility = ObservableBoolean(false)

    private val _noDataMsgTxt = MutableLiveData<String>()
    val noDataMsgTxt: LiveData<String> get() = _noDataMsgTxt

    private val _noDataTitleTxt = MutableLiveData<String>()
    val noDataTitleTxt: LiveData<String> get() = _noDataTitleTxt
    fun showNoDataView(){
        dataLayoutVisibility.set(false)
        noDataLayoutVisibility.set(true)
        _noDataTitleTxt.value = context.getString(R.string.no_data_found)
        _noDataMsgTxt.value="The user has not favorited any videos yet."
    }

    fun showDataView(){
        dataLayoutVisibility.set(true)
        noDataLayoutVisibility.set(false)
    }

    fun showBlockView(){
        noDataLayoutVisibility.set(true)
        _noDataTitleTxt.value = context.getString(R.string.alert)
        _noDataMsgTxt.value=context.getString(R.string.you_are_block_by)+ " " + userName
    }

}

